/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.mixinFunctions;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.UUID;
import java.util.function.Supplier;

public interface IPlayerEntity<T>
extends IEmotePlayerEntity<EmotePlayer<T>> {
    public static final int FPPerspective = 0;
    public static final Supplier<Integer> TPBPerspective = () -> (Boolean)((ClientConfig)EmoteInstance.config).frontAsTPPerspective.get() != false ? 2 : 1;

    default public void initEmotePlay() {
        Pair<EmoteData, Integer> p = ClientEmotePlay.getEmoteForUUID(this.emotes_getUUID());
        if (p != null) {
            this.playEmote(p.getLeft(), p.getRight());
        }
        if (!this.isMainPlayer() && EmoteInstance.instance.getClientMethods().getMainPlayer() != null && EmoteInstance.instance.getClientMethods().getMainPlayer().isPlayingEmote()) {
            IEmotePlayerEntity playerEntity = EmoteInstance.instance.getClientMethods().getMainPlayer();
            ClientEmotePlay.clientRepeatLocalEmote(playerEntity.getEmote().getData(), playerEntity.getEmote().getTick(), this.emotes_getUUID());
        }
    }

    default public void initEmotePerspective(EmotePlayer emotePlayer) {
        if (((ClientConfig)EmoteInstance.config).enablePerspective.get().booleanValue() && this.isMainPlayer() && EmoteInstance.instance.getClientMethods().getPerspective() == 0) {
            emotePlayer.perspective = 1;
            EmoteInstance.instance.getClientMethods().setPerspective(TPBPerspective.get());
        }
    }

    @Override
    default public boolean isPlayingEmote() {
        return EmotePlayer.isRunningEmote((EmotePlayer)this.getEmote());
    }

    @Override
    default public boolean isMainPlayer() {
        return EmoteInstance.instance.getClientMethods().getMainPlayer() == this;
    }

    public int emotes_getAge();

    public int emotes_getAndIncreaseAge();

    @Override
    default public void emoteTick() {
        if (this.emotes_getAge() <= 1 && this.emotes_getAndIncreaseAge() == 1) {
            this.initEmotePlay();
        }
        if (this.isPlayingEmote()) {
            this.setBodyYaw(this.getViewYaw());
            this.emoteTickCallback();
            if (this.isMainPlayer() && ((EmotePlayer)this.getEmote()).perspective == 1 && EmoteInstance.instance.getClientMethods().getPerspective() != TPBPerspective.get().intValue()) {
                ((EmotePlayer)this.getEmote()).perspective = 0;
            }
            if (!this.isMainPlayer() || EmoteHolder.canRunEmote(this)) {
                ((EmotePlayer)this.getEmote()).tick();
            } else {
                ((EmotePlayer)this.getEmote()).stop();
                ClientEmotePlay.clientStopLocalEmote(((EmotePlayer)this.getEmote()).getData());
            }
        }
    }

    @Override
    default public void stopEmote() {
        if (this.getEmote() != null) {
            ((EmotePlayer)this.getEmote()).stop();
            this.voidEmote();
        }
    }

    @Override
    default public void stopEmote(UUID emoteID) {
        if (this.getEmote() != null && ((EmotePlayer)this.getEmote()).getData().getUuid().equals(emoteID)) {
            ((EmotePlayer)this.getEmote()).stop();
            this.voidEmote();
        }
    }

    public void voidEmote();
}

